@extends('layouts.admin')

@section('content')
    <!-- Page Header -->
    <div class="py-6 bg-[#F6F6F6] border-b border-[#CBB4B0]">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-3xl font-bold text-gray-900">Kelola Kredensial Pasien</h1>
                    <p class="text-gray-600 mt-1">Generate MRN dan password untuk pasien yang belum memiliki kredensial</p>
                </div>
                <div class="flex items-center space-x-4">
                    <a href="{{ route('admin.patients.index') }}" 
                       class="bg-[#8B8B8B] text-white px-4 py-2 rounded-none hover:bg-[#192D50] transition duration-150">
                        Daftar Pasien
                    </a>
                    <a href="{{ route('admin.payments.index') }}" 
                       class="bg-[#192D50] text-white px-4 py-2 rounded-none hover:bg-[#8B8B8B] transition duration-150">
                        Pembayaran
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="py-8 bg-[#F6F6F6]">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Stats Cards -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
                <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none border border-[#CBB4B0]">
                    <div class="p-6">
                        <div class="flex items-center">
                            <div class="flex-shrink-0">
                                <div class="w-8 h-8 bg-[#192D50] rounded-full flex items-center justify-center">
                                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                    </svg>
                                </div>
                            </div>
                            <div class="ml-4">
                                <p class="text-sm font-medium text-gray-500">Belum Ada Kredensial</p>
                                <p class="text-2xl font-semibold text-gray-900">{{ $patients->total() }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none border border-[#CBB4B0]">
                    <div class="p-6">
                        <div class="flex items-center">
                            <div class="flex-shrink-0">
                                <div class="w-8 h-8 bg-[#8B8B8B] rounded-full flex items-center justify-center">
                                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                    </svg>
                                </div>
                            </div>
                            <div class="ml-4">
                                <p class="text-sm font-medium text-gray-500">Sudah Ada Kredensial</p>
                                <p class="text-2xl font-semibold text-gray-900">{{ \App\Models\Patient::whereNotNull('mrn')->where('mrn', '!=', '')->count() }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none border border-[#CBB4B0]">
                    <div class="p-6">
                        <div class="flex items-center">
                            <div class="flex-shrink-0">
                                <div class="w-8 h-8 bg-[#192D50] rounded-full flex items-center justify-center">
                                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
                                    </svg>
                                </div>
                            </div>
                            <div class="ml-4">
                                <p class="text-sm font-medium text-gray-500">Total Pasien</p>
                                <p class="text-2xl font-semibold text-gray-900">{{ \App\Models\Patient::count() }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="bg-white overflow-hidden shadow-sm sm:rounded-none">
                <div class="p-6 text-gray-900">
                    <div class="flex justify-between items-center mb-6">
                        <h3 class="text-lg font-medium text-gray-900">Pasien yang Belum Memiliki Kredensial</h3>
                    </div>

                    @if($patients->count() > 0)
                        <div class="overflow-x-auto">
                            <table class="min-w-full divide-y divide-gray-200">
                                <thead class="bg-[#192D50]">
                                    <tr>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nama</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Email</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Telepon</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Registrasi</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Aksi</th>
                                    </tr>
                                </thead>
                                <tbody class="bg-[#F6F6F6] divide-y divide-[#CBB4B0]">
                                    @foreach($patients as $patient)
                                        <tr>
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                <div class="text-sm font-medium text-gray-900">{{ $patient->name }}</div>
                                                <div class="text-sm text-gray-500">{{ $patient->ktp_number }}</div>
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $patient->email }}</td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $patient->phone }}</td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $patient->registrations->count() }}</td>
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-[#192D50] text-white">
                                                    Belum Ada Kredensial
                                                </span>
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                                <a href="{{ route('admin.patient-management.credentials-form', $patient) }}" 
                                                   class="text-[#CBB4B0] hover:text-[#8B8B8B] bg-[#F6F6F6] hover:bg-[#192D50] hover:text-white px-3 py-1 rounded-none text-sm font-medium transition duration-150 border border-[#CBB4B0]">
                                                    Generate Kredensial
                                                </a>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <div class="mt-6">
                            {{ $patients->links() }}
                        </div>
                    @else
                        <div class="text-center py-8">
                            <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-[#8B8B8B]">
                                <svg class="h-6 w-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                            </div>
                            <h3 class="mt-4 text-lg font-medium text-gray-900">Semua Pasien Sudah Memiliki Kredensial</h3>
                            <p class="mt-2 text-sm text-gray-600">
                                Semua pasien sudah memiliki MRN dan password untuk akses portal.
                            </p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection
